/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.PolyOrientedCurve2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.point.PointSet2DUtils;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polyline2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Polyline2DUtils {
    public static final boolean hasMultipleVertices(Polyline2D polyline) {
        return Polyline2DUtils.hasMultipleVertices(polyline, false);
    }

    public static final boolean hasMultipleVertices(Polyline2D polyline, boolean closed) {
        Point2D p2;
        Point2D p1;
        if (PointSet2DUtils.hasAdjacentMultipleVertices(polyline.vertices)) {
            return true;
        }
        return closed && (p1 = polyline.getFirstPoint()).getDistance(p2 = polyline.getLastPoint()) < 1.0E-12;
    }

    @Deprecated
    public static PolyOrientedCurve2D<SmoothOrientedCurve2D> createParallel(Polyline2D polyline, double d) {
        Point2D p2;
        Point2D p1;
        StraightLine2D line;
        Point2D v1;
        Iterator<Point2D> iterator;
        Point2D v2;
        StraightLine2D line0;
        PolyOrientedCurve2D<SmoothOrientedCurve2D> result = new PolyOrientedCurve2D<SmoothOrientedCurve2D>();
        result.setClosed(polyline instanceof LinearRing2D);
        if (polyline.getVertices().size() < 2) {
            return result;
        }
        Point2D p0 = null;
        if (polyline instanceof LinearRing2D) {
            LineSegment2D lastEdge = polyline.getLastEdge();
            line0 = StraightLine2D.createParallel((LinearShape2D)lastEdge, d);
            v2 = lastEdge.getLastPoint();
            p0 = line0.getProjectedPoint(v2);
            iterator = polyline.getVertices().iterator();
            v1 = iterator.next();
            v2 = iterator.next();
            line = new StraightLine2D(v1, v2).getParallel(d);
            p1 = line.getProjectedPoint(v1);
            if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
                p0 = p1 = line.getIntersection(line0);
            } else {
                Polyline2DUtils.addCircleArc(result, v1, p0, p1, d);
            }
            p2 = line.getProjectedPoint(v2);
            line0 = line;
        } else {
            iterator = polyline.getVertices().iterator();
            v1 = iterator.next();
            v2 = iterator.next();
            line0 = new StraightLine2D(v1, v2).getParallel(d);
            p1 = line0.getProjectedPoint(v1);
            p2 = line0.getProjectedPoint(v2);
        }
        while (iterator.hasNext()) {
            v1 = v2;
            line = new StraightLine2D(v1, v2 = iterator.next()).getParallel(d);
            if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
                p2 = line.getIntersection(line0);
                result.addCurve(new LineSegment2D(p1, p2));
                p1 = p2;
            } else {
                result.addCurve(new LineSegment2D(p1, p2));
                Polyline2DUtils.addCircleArc(result, v1, p2, p1, d);
            }
            p2 = line.getProjectedPoint(v2);
            line0 = line;
        }
        if (polyline instanceof LinearRing2D) {
            v1 = v2;
            iterator = polyline.getVertices().iterator();
            line = new StraightLine2D(v1, v2 = iterator.next()).getParallel(d);
            if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
                p2 = line.getIntersection(line0);
                result.addCurve(new LineSegment2D(p1, p2));
                p1 = p2;
            } else {
                result.addCurve(new LineSegment2D(p1, p2));
                Polyline2DUtils.addCircleArc(result, v1, p2, p1, d);
            }
            result.addCurve(new LineSegment2D(p1, p0));
        } else {
            result.addCurve(new LineSegment2D(p1, p2));
        }
        return result;
    }

    @Deprecated
    public static BoundaryPolyCurve2D<SmoothOrientedCurve2D> createClosedParallel(LinearRing2D polyline, double d) {
        BoundaryPolyCurve2D<SmoothOrientedCurve2D> result = new BoundaryPolyCurve2D<SmoothOrientedCurve2D>();
        result.setClosed(true);
        if (polyline.getVertices().size() < 2) {
            return result;
        }
        Point2D p0 = null;
        LineSegment2D lastEdge = polyline.getLastEdge();
        StraightLine2D line0 = StraightLine2D.createParallel((LinearShape2D)lastEdge, d);
        Point2D v2 = lastEdge.getLastPoint();
        p0 = line0.getProjectedPoint(v2);
        Iterator<Point2D> iterator = polyline.getVertices().iterator();
        Point2D v1 = iterator.next();
        v2 = iterator.next();
        StraightLine2D line = new StraightLine2D(v1, v2).getParallel(d);
        Point2D p1 = line.getProjectedPoint(v1);
        if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
            p0 = p1 = line.getIntersection(line0);
        } else {
            Polyline2DUtils.addCircleArc(result, v1, p0, p1, d);
        }
        Point2D p2 = line.getProjectedPoint(v2);
        line0 = line;
        while (iterator.hasNext()) {
            v1 = v2;
            line = new StraightLine2D(v1, v2 = iterator.next()).getParallel(d);
            if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
                p2 = line.getIntersection(line0);
                result.addCurve(new LineSegment2D(p1, p2));
                p1 = p2;
            } else {
                result.addCurve(new LineSegment2D(p1, p2));
                Polyline2DUtils.addCircleArc(result, v1, p2, p1, d);
            }
            p2 = line.getProjectedPoint(v2);
            line0 = line;
        }
        v1 = v2;
        iterator = polyline.getVertices().iterator();
        line = new StraightLine2D(v1, v2 = iterator.next()).getParallel(d);
        if (Angle2D.getAngle(line0, line) > Math.PI ^ d < 0.0) {
            p2 = line.getIntersection(line0);
            result.addCurve(new LineSegment2D(p1, p2));
            p1 = p2;
        } else {
            result.addCurve(new LineSegment2D(p1, p2));
            Polyline2DUtils.addCircleArc(result, v1, p2, p1, d);
        }
        result.addCurve(new LineSegment2D(p1, p0));
        return result;
    }

    private static void addCircleArc(PolyCurve2D<SmoothOrientedCurve2D> result, Point2D v1, Point2D p1, Point2D p2, double d) {
        Circle2D circle = new Circle2D(v1, Math.abs(d));
        double t0 = circle.getPosition(p1);
        double t1 = circle.getPosition(p2);
        result.addCurve(new CircleArc2D(v1, Math.abs(d), t0, t1, d > 0.0));
    }

    public static Collection<Point2D> intersect(Polyline2D poly1, Polyline2D poly2) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (LineSegment2D edge1 : poly1.getEdges()) {
            for (LineSegment2D edge2 : poly2.getEdges()) {
                Point2D point = edge1.getIntersection(edge2);
                if (point == null || points.contains(point)) continue;
                points.add(point);
            }
        }
        return points;
    }
}

